<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();

            // Polymorphic relation to customers or corporate customers
            $table->enum('owner_type', ['customer', 'corporate_customer'])->index();
            $table->unsignedBigInteger('owner_id')->index();

            // Document details
            $table->string('document_type')->index(); // e.g., ID, passport, license, utility_bill, etc.
            $table->string('title')->nullable();      // Optional title
            $table->string('file_path');              // Path to file (local or cloud storage)
            $table->string('file_name');              // Original file name
            $table->string('file_extension')->nullable();
            $table->string('mime_type')->nullable();
            $table->unsignedBigInteger('file_size')->nullable(); // In bytes

            // Optional verification and tracking
            $table->boolean('is_verified')->default(false);
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->nullOnDelete();

            $table->foreignId('uploaded_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('uploaded_at')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
